@extends('layouts.app')

@section('title', '503 Service Unavailable')

@section('content')
<div class="error-container">
    <div class="error-image">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" class="feather feather-alert-triangle">
            <path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z" fill="rgba(255,255,255,0.1)" stroke="{{ config('variables.primary-color', '#3d84ff') }}"></path>
            <line x1="12" y1="9" x2="12" y2="13" stroke="{{ config('variables.primary-color', '#3d84ff') }}"></line>
            <circle cx="12" cy="17" r="1" fill="{{ config('variables.primary-color', '#3d84ff') }}"></circle>
        </svg>
    </div>
    
    <h1 class="error-code">503</h1>
    <h2 class="error-title">Service Unavailable</h2>
    
    <p class="error-message">
        The server is temporarily unable to handle your request. This could be due to maintenance or high traffic.  
        Please try again later.
    </p>
    
    <div class="error-actions">
        <a href="{{ url()->previous() }}" class="btn btn-primary">Go Back</a>
        <a href="{{ url('/') }}" class="btn btn-secondary">Home</a>
    </div>
</div>
@endsection
